require( "scripts/style.lua" );


kImageY = 5;
kButtonX = 40;
kButtonY = 70;
kButtonSpacing = 50;
kTextX = 0;

kHeaderY = 30;
kLevelX = 10;
kLevelWidth = 100;
kRatingX = 135;
kRatingWidth = 350;
kStatusX = 525;
kStatusWidth = 100;

HeaderFont = {
	standardFont,
	46,
	BlackColor
};

SubHeaderFont = {
	standardFont,
	24,
	BlackColor
};

LevelIndicatorFont = {
	standardFont,
	28,
	BlackColor
};
TitleFont = {
	standardFont,
	64,
	BlackColor
};
EntryFont = {
	proportionalFont,
	26,
	BlackColor
};

MakeDialog
{
	Bitmap
	{
		name="backgroundimage",
		image="backgrounds/fullscreendialog",
		x=0,y=0,w=kMax,h=kMax,

		Text
		{
			font = TitleFont,
			label="lockedlevels",
			x=kCenter,
			y=20,
			w=kMax,
			h=85,
			flags = kHAlignCenter + kVAlignTop,
			padding = 0
		},

		
		Bitmap
		{
			image="map/secret_levels_window",
			x = kCenter, y =kCenter,
			
			LockedLevels
			{
				x = 0, y = 0, w=kMax, h=kMax,
				
				Bitmap
				{
					x = 170, y = 29,
					w = 60, h = 60,
					scale = 1.9,
					name = 'restaurant_icon'
				},
				
				Text
				{
					font = HeaderFont,
					label="",
					name="levelname",
					x=240,
					y=20,
					w=kMax,
					h=50,
					flags = kHAlignLeft + kVAlignTop,
					padding = 0
				};
				
				Text
				{
					font = SubHeaderFont,
					label="",
					name="levelnamedescrip",
					x=240,
					y=60,
					w=kMax,
					h=44,
					flags = kHAlignLeft + kVAlignTop,
					padding = 0
				};
				
				Text
				{
					font = EntryFont,
					label="",
					name="leveldescrip",
					x=100,
					y=140,
					w=kMax-100,
					h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					padding = 0
				};
				
				Button
				{
					x=10,
					y=kCenter,
					graphics = LeftArrowGraphics,
					name="left",
					type = kPush,
					scale = 0.5,
					command=
						function()
							IncrementLockedLevel(-1)
							EnableWindow("left",CanDecrementLockedLevel());			
							EnableWindow("right",true);		
						end
				},
				
				Button
				{
					x=-75,
					y=kCenter,
					graphics = LeftArrowGraphics,
							hflip = true,
					name="right",
					type = kPush,
					scale = 0.5,
					command=
						function()
							IncrementLockedLevel(1)
							EnableWindow("right",CanIncrementLockedLevel());
							EnableWindow("left", true);							
						end
				},
				
				Text 
				{
					label="",
					name="levelindicator",
					x=kCenter,
					y=-100,
					w=kMax,
					h=30,
					font=LevelIndicatorFont,
					flags=kHAlignCenter + kVAlignTop
				},
				
				SetStyle(StandardButtonStyle);
				Button
				{
					x=kCenter,
					y=-50,
					name="playlockedlevel",
					label="play",
					command=
						function()
							SetLevelMode(1);
							SetCurrentGameMode(0);
							SetOneOffLevelName(GetFullLevelName());
							SetOneOffLevelDescription(GetDescription());
							SetLevelInfoToOneOffLevel();
							ReleaseMapAssets();
							PopModal("scripts/chooserestaurant.lua");
							DoModal("scripts/game.lua");
						end
				},
				SetStyle(DefaultStyle);
			};
		};
		
			
		
		SetStyle(StandardButtonStyle);
		Button
		{
			x=kCenter,
			y=520,
			name="back",
			label="back",
			command=
				function()
					PopModal("scripts/lockedlevels.lua");
				end
		},
		SetStyle(DefaultStyle);
		
			
	},
	
};
